package gg7;

import gg7.Md.Prj;
import gg7.Md.Sst;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Vw { // vw = viewer

    public class IB extends JButton { // ib = informed button
        String type;

        int x, y;

        public IB(String label, String type) {
            super(label);

            this.type = type;
        }

        public IB(String label, String type, int x) {
            super(label);

            this.type = type;

            this.x = x;
        }

        public IB(String label, String type, int x, int y) {
            super(label);

            this.type = type;

            this.x = x;
            this.y = y;
        }
    }

    public class Cns extends JFrame implements ActionListener, WindowListener { // cns = console
        Vw vw;

        boolean pl, // pl = play
                taa; // taa = team assignments active

        IB
            bw, // bw = backward
            pb, // pb = play/browse
            fw; // fw = forward
        IB[]
            ta, // ta = team assignments
            sr; // sr = status report

        JLabel
            md, // md = mode
            yl, // yl = year label
            yr, // yr = year
            ml, // ml = maintenance label
            mc; // mc = maintenance costs
        JLabel[]
            to; // to = turnover

        public Cns(Vw vw) {
            this.vw = vw;

            pl = true;
            taa = false;

            this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
            this.addWindowListener(this);
            this.setSize(625, 200);
            this.setLocation(25, 25);
            this.setTitle("console maintenance factor " + Integer.toString(Cs.ms));

            Container wd = this.getContentPane(); // wd = window
            wd.setLayout(new GridBagLayout());

            GridBagConstraints gc = new GridBagConstraints(); // gc = gridbagconstraints
            gc.fill = GridBagConstraints.BOTH;
            gc.weightx = 1;
            gc.weighty = 1;
            gc.insets = new Insets(3, 3, 3, 3);

            this.ta = new IB[Cs.tm];
            this.sr = new IB[Cs.tm];

            this.to = new JLabel[Cs.tm];

            for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                this.ta[ti] = new IB("assignments", "team assignments", ti);
                this.ta[ti].setBackground(Cs.clr[ti]);
                this.ta[ti].addActionListener(this);
                gc.gridx = 0;
                gc.gridy = ti;
                wd.add(ta[ti], gc);

                this.to[ti] = new JLabel();
                this.to[ti].setHorizontalAlignment(JLabel.CENTER);
                this.to[ti].setBackground(Color.LIGHT_GRAY);
                this.to[ti].setOpaque(true);
                gc.gridx = 1;
                gc.gridy = ti;
                wd.add(to[ti], gc);

                this.sr[ti] = new IB("status report", "status report", ti);
                this.sr[ti].setBackground(Cs.clr[ti]);
                this.sr[ti].addActionListener(this);
                gc.gridx = 2;
                gc.gridy = ti;
                wd.add(sr[ti], gc);
            }

            gc.gridx = 3;
            gc.insets = new Insets(3, 3, 3, 0);

            this.yl = new JLabel("year");
            this.yl.setHorizontalAlignment(JLabel.CENTER);
            this.yl.setBackground(Color.LIGHT_GRAY);
            this.yl.setOpaque(true);
            gc.gridy = 0;
            wd.add(yl, gc);

            this.ml = new JLabel("maintenance");
            this.ml.setHorizontalAlignment(JLabel.CENTER);
            this.ml.setBackground(Color.LIGHT_GRAY);
            this.ml.setOpaque(true);
            gc.gridy = 1;
            wd.add(ml, gc);

            gc.gridx = 4;
            gc.insets = new Insets(3, 0, 3, 3);

            this.yr = new JLabel();
            this.yr.setHorizontalAlignment(JLabel.CENTER);
            this.yr.setBackground(Color.LIGHT_GRAY);
            this.yr.setOpaque(true);
            gc.gridy = 0;
            wd.add(yr, gc);

            this.mc = new JLabel();
            this.mc.setHorizontalAlignment(JLabel.CENTER);
            this.mc.setBackground(Color.LIGHT_GRAY);
            this.mc.setOpaque(true);
            gc.gridy = 1;
            wd.add(mc, gc);

            Container nav = new Container(); // nav = navigator
            nav.setLayout(new GridBagLayout());

            gc.gridx = 1;
            gc.insets = new Insets(3, 3, 3, 3);

            this.pb = new IB("mode","pb");
            this.pb.addActionListener(this);
            gc.gridy = 0;
            nav.add(pb, gc);

            this.md = new JLabel();
            this.md.setBackground(Color.LIGHT_GRAY);
            this.md.setHorizontalAlignment(JLabel.CENTER);
            this.md.setOpaque(true);
            gc.gridy = 1;
            nav.add(md, gc);

            gc.gridheight = 2;
            gc.gridy = 0;

            this.bw = new IB("<<", "bw");
            this.bw.addActionListener(this);
            gc.gridx = 0;
            nav.add(bw, gc);

            this.fw = new IB(">>", "fw");
            this.fw.addActionListener(this);
            gc.gridx = 2;
            nav.add(fw, gc);

            gc.gridwidth = 2;
            gc.gridx = 3;
            gc.gridy = 2;
            gc.insets = new Insets(0, 0, 0, 0);
            wd.add(nav, gc);

            this.setVisible(true);
        }

        public void rfr() {
            int[] to = new int[Cs.tm]; // to = turnover
            int[] sto; // sto = turnover for one segment

            this.yr.setText(Integer.toString(this.vw.md.yr));
            this.mc.setText(Integer.toString(this.vw.md.mc()));

            if (this.taa || (this.vw.md.yr < 2 &&
                (this.pl && this.vw.md.b2p || !this.pl && this.vw.mn.hst.prv == null)))
                this.bw.setEnabled(false);
            else this.bw.setEnabled(true);

            if (!this.taa && (this.pl || this.vw.mn.hst.nxt != null)) this.fw.setEnabled(true);
            else this.fw.setEnabled(false);

            if (pl) {
                this.md.setText("play");
                this.md.setBackground(Color.red);
            }
            else {
                this.md.setText("view");
                this.md.setBackground(Color.green);
            }

            for(int ti = 0; ti < Cs.tm; ti++) {
                if (this.pl && !this.taa && this.vw.md.b2p) this.sr[ti].setEnabled(true);
                else this.sr[ti].setEnabled(false);

                if (this.pl && !this.taa) this.ta[ti].setEnabled(true);
                else this.ta[ti].setEnabled(false);
            }

            if (this.taa) this.pb.setEnabled(false);
            else this.pb.setEnabled(true);

            for(int ti = 0; ti < Cs.tm; ti++) {
                to[ti] = 0;
            }

            for(int smi = 0; smi < Cs.sgm; smi++) {
                sto = this.vw.md.to(smi);

                for(int tmi = 0; tmi < Cs.tm; tmi++) {
                    to[tmi] = to[tmi] + sto[tmi];
                }
            }

            for(int ti = 0; ti < Cs.tm; ti++)
                this.to[ti].setText(Integer.toString(to[ti]));
        }

        public void actionPerformed(ActionEvent e) {
            Prj[][] ppf = this.vw.md.ppf;
            Sst[][][] apf = this.vw.md.apf;
            int yr = this.vw.md.yr;

            IB bP = (IB) e.getSource(); // bp = button pressed

            if (bP.type.equals("team assignments")) {
                new TA(this.vw, bP.x);
                this.taa = true;
            }

            if (bP.type.equals("status report")) {
                new SR(this.vw.mn, bP.x);
            }

            if (bP.type.equals("pb")) {
                this.pl = !this.pl;

                if (this.pl) {
                    this.vw.mn.hst.nxt = null;
                    this.vw.mn.md = this.vw.mn.hst.md.cMd();
                    this.vw.md = this.vw.mn.md.cMd();
                }
            }

            if (bP.type.equals("bw")) {
                if (this.pl) {
                    if (this.vw.md.b2p) this.vw.md.yr--;

                    this.vw.md.nY(this.vw.md.yr - 1);
                    this.vw.md.ps = 0;
                    this.vw.md.sp = 0;
                    this.vw.mn.md = this.vw.md.cMd();
                    this.vw.mn.hst.add(this.vw.mn.md);

                    this.vw.md.b2p = true;
                }
                else {
                    this.vw.mn.hst = this.vw.mn.hst.prv;
                    this.vw.md = this.vw.mn.hst.md;
                }
            }

            if (bP.type.equals("fw")) {
                if (this.pl) {
// should be a method of Md...

// finished renewal projects result in renewal of the corresponding application
// ie lcl = 0 (will become 1 in next for-loop)
// and project is removed
                    for(int li = 0; li < Cs.ln; li++) {
                        if (ppf[yr][li].prj && ppf[yr][li].tp == 4 && ppf[yr][li].sts == 2) {
                            apf[yr][ppf[yr][li].sgm][ppf[yr][li].tm].lcl = 0;
                            ppf[yr][li].prj = false;
                        }
                    }

    // applications get lcl++ if maintained and not end of life, otherwise get killed
                    for(int smi = 0; smi < Cs.sgm; smi++) {
                        for(int ti = 0; ti < Cs.tm; ti++) {
                            if (apf[yr][smi][ti].sst && apf[yr][smi][ti].mnt && apf[yr][smi][ti].lcl < 5) {
                                apf[yr][smi][ti].lcl++;
                                apf[yr][smi][ti].mnt = false;
                            }
                            else apf[yr][smi][ti].sst = false;
                        }
                    }

    // in the next step nSP will be called on Mn-md which has to reflect the status
    // of the application portfolio after processing the previuous step
                    this.vw.mn.md = this.vw.md.cMd();

    // process project portfolio
                    for(int li = 0; li < Cs.ln; li++) {
                        if (ppf[yr][li].prj) {
    // if project is finished an application is added to the application portfolio
    // and project is removed
                            if (ppf[yr][li].sts == Cs.np[ppf[yr][li].tp]) {
                                if (this.vw.mn.md.nSP(ppf[yr][li].sgm)) {
                                    switch(ppf[yr][li].tp) {
                                        case 0:
                                        case 1:
                                            this.vw.md.nS(ppf[yr][li].sgm, ppf[yr][li].tm, false);
                                            break;
                                        case 2:
                                            this.vw.md.nS(ppf[yr][li].sgm, ppf[yr][li].tm, true);
                                            break;
                                        case 3:
                                            apf[yr][ppf[yr][li].sgm][ppf[yr][li].tm].arc = true;
    // case 4 (renewal projects) was handled in first for-loop
                                    }
                                }

                                ppf[yr][li].prj = false;
                            }
                            else {
    // if project was not executed during this year one phase gets killed
                                if (ppf[yr][li].sts == ppf[yr - 1][li].sts)
                                    ppf[yr][li].sts--;

    // projects with no finished phases left get killed
                                if (ppf[yr][li].sts < 0)
                                    ppf[yr][li].prj = false;
                            }

    // py = number of pases done this year is reset to 0
                            ppf[yr][li].py = 0;
                        }
                    }

                    this.vw.md.nY(yr);
                    this.vw.md.yr++;
                    this.vw.md.ps = 0;
                    this.vw.md.sp = 0;
                    this.vw.md.b2p = true;
                    this.vw.mn.md = this.vw.md.cMd();
                    this.vw.mn.hst.add(this.vw.mn.md);
                }
                else {
                    this.vw.mn.hst = this.vw.mn.hst.nxt;
                    this.vw.md = this.vw.mn.hst.md;
                }
            }
            this.vw.rfr();
        }

        public void windowOpened(WindowEvent arg0) {
        }

        public void windowClosing(WindowEvent arg0) {
            new Cf();
        }

        public void windowClosed(WindowEvent arg0) {
        }

        public void windowIconified(WindowEvent arg0) {
        }

        public void windowDeiconified(WindowEvent arg0) {
        }

        public void windowActivated(WindowEvent arg0) {
        }

        public void windowDeactivated(WindowEvent arg0) {
        }
    }

    public class TA extends JFrame implements ActionListener { // ta = team assignments
        Vw vw;
        int
            tm, // tm = team
            sp; // sp = number of started projects

        JLabel tcf; // tcf = total costs field

        IB
            ccl, // ccl = cancel
            ok;

        IB[]
            pt, // pt = project type
            np, // np = new project
            mp; // mp = maintain project

        IB[][] xp; // xp = execute project

// the variables pt and np constitute a little model that keeps track of
// new projects started
        int
            prt, // pt = new project type
            npr, // np = new project segment
            tc; // tc = total costs

        int[] s2l; // s2l = mapping form segment to lane

        public TA(Vw vw, int tm) {
            this.vw = vw;
            this.tm = tm;
            this.sp = this.vw.md.sp;

            this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
            this.setSize(700, 300);
            this.setLocation(200, 200);
            this.setTitle("assignments " + Cs.nm[this.tm]);

            Container wd = this.getContentPane();
            wd.setLayout(new GridBagLayout());

            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = GridBagConstraints.BOTH;
            gc.weightx = 1;
            gc.weighty = 1;
            gc.insets = new Insets(3, 3, 3, 3);

            gc.gridx = 10;
            tcf = new JLabel("0");
            tcf.setHorizontalAlignment(JLabel.CENTER);
            gc.gridy = 4;
            wd.add(tcf, gc);

            ok = new IB("ok", "ok");
            ok.addActionListener(this);
            gc.gridy = 5;
            wd.add(ok, gc);

            ccl = new IB("cancel", "cancel");
            ccl.addActionListener(this);
            gc.gridy = 6;
            wd.add(ccl, gc);

            pt = new IB[Cs.pt];
            np = new IB[Cs.sgm];
            mp = new IB[Cs.sgm];

            xp = new IB[Cs.sgm][Cs.msp];

            gc.gridx = 0;
            for(int pti = 0; pti < Cs.pt; pti++) { // = project type index
                pt[pti] = new IB(Cs.tn[pti], "project type", pti);
                pt[pti].addActionListener(this);
                gc.gridy = pti;
                wd.add(pt[pti], gc);
            }

            for(int smi = 0; smi < Cs.sgm; smi++) { // smi = segment index
                gc.gridy = 0;
                np[smi] = new IB(Integer.toString(smi + 1), "new project", smi);
                np[smi].addActionListener(this);
                gc.gridx = smi + 1;
                wd.add(np[smi], gc);

                gc.gridy = 6;
                mp[smi] = new IB(Integer.toString(smi + 1), "maintain project", smi);
                mp[smi].addActionListener(this);
                gc.gridx = smi + 1;
                wd.add(mp[smi], gc);

                for(int sp = 0; sp < Cs.msp; sp++) {
                    xp[smi][sp] = new IB("", "execute project", smi, sp);
                    xp[smi][sp].addActionListener(this);
                    gc.gridx = smi + 1;
                    gc.gridy = sp + 2;
                    wd.add(xp[smi][sp], gc);
                }
            }

            prt = 9; // 9 = no project type selected
            npr = 9; // 9 = no segment selected
            tc = 0;

            this.s2l = new int[Cs.sgm];

            this.rfr();

            this.setVisible(true);
        }

        public void rfr() { // rfr = refresh
            Prj[] prj = this.vw.md.ppf[this.vw.md.yr];

            this.tcf.setText(Integer.toString(this.tc));

// if no system present or system has already been maintained mp disabled
            for(int smi = 0; smi < Cs.sgm; smi++) { // smi = segment index
                if (!this.vw.md.apf[this.vw.md.yr][smi][this.tm].sst ||
                    this.vw.md.apf[this.vw.md.yr][smi][this.tm].mnt)
                    this.mp[smi].setEnabled(false);

// disable all xp now, enable selected xp later on
                for(int pi = 0; pi < Cs.msp; pi++) { // pi = phase index
                    this.xp[smi][pi].setText("");
                    this.xp[smi][pi].setEnabled(false);
                }
            }

// reset s2l[] and populate in next for-loop
            for(int smi = 0; smi < Cs.sgm; smi++) {
                this.s2l[smi] = 9;
            }

// enable selected xp
            for(int li = 0; li < Cs.ln; li++) { // li = lane index
                if (prj[li].prj && prj[li].tm == this.tm) {
                    for(int pi = 0; pi < Math.min(
                        Cs.np[prj[li].tp] - prj[li].sts, Math.min(
                        Cs.mps - this.vw.md.ps,
                        Cs.msp - prj[li].py)); pi++) { // pi = phase index
                        this.xp[prj[li].sgm][pi].setText(Integer.toString(
                            Cs.xc[prj[li].tp][pi + prj[li].py + 1] -
                            Cs.xc[prj[li].tp][prj[li].py]));
                        this.xp[prj[li].sgm][pi].setEnabled(true);
                    }

                    this.s2l[prj[li].sgm] = li;
                }
            }

// if still place for new projects
            if (this.vw.md.ffl() < Cs.ln && this.sp < Cs.mnp) {
                for(int smi = 0; smi < Cs.sgm; smi++)
                    this.np[smi].setEnabled(true);
                for(int pi = 0; pi < Cs.pt; pi++)
                    this.pt[pi].setEnabled(true);

// if segment choosen for new project
                if (this.npr != 9) {
                    for(int smi = 0; smi < Cs.sgm; smi++) // smi = segment index
                        if (smi != this.npr) this.np[smi].setEnabled(false);

                    if (this.vw.md.apf[this.vw.md.yr][this.npr][this.tm].sst) {
                        for(int pi = 0; pi < 3; pi++) // pi = project type index
                            this.pt[pi].setEnabled(false);
                        if (this.vw.md.apf[this.vw.md.yr][this.npr][this.tm].arc)
                            this.pt[3].setEnabled(false);
                    }
                    else {
                        for(int pi = 3; pi < Cs.pt; pi++)
                            this.pt[pi].setEnabled(false);
                    }
                }
            }
// if no place for new projects
            else {
                for(int smi = 0; smi < Cs.sgm; smi++)
                    this.np[smi].setEnabled(false);
                for(int pi = 0; pi < Cs.pt; pi++)
                    this.pt[pi].setEnabled(false);
                for(int li = 0; li < Cs.ln; li++)
                    if (prj[li].prj && prj[li].tm == this.tm)
                        this.np[prj[li].sgm].setEnabled(true);
            }

// if project type choosen for new project
            if (this.prt != 9) {
                for(int pi = 0; pi < Cs.pt; pi++) // pi = project type index
                    if (pi != this.prt) this.pt[pi].setEnabled(false);

                for(int smi = 0; smi < Cs.sgm; smi++) { // smi = segment index
                    if (this.s2l[smi] != 9)
                        this.np[smi].setEnabled(false);

                    if (this.vw.md.apf[this.vw.md.yr][smi][this.tm].sst) {
                        if (this.vw.md.apf[this.vw.md.yr][smi][this.tm].arc) {
                            if (this.prt != 4)
                                this.np[smi].setEnabled(false);
                        }
                        else {
                            if (this.prt < 3)
                                this.np[smi].setEnabled(false);
                        }
                    }
                    else {
                        if (this.prt > 2)
                            this.np[smi].setEnabled(false);
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            IB bP = (IB) e.getSource();
            Prj prj;

            if (bP.type.equals("ok")) {
                for(int li = 0; li < Cs.ln; li++)
                    this.vw.md.ppf[this.vw.md.yr][li].js = false;
                this.vw.md.sp = this.sp;
                this.vw.md.b2p = false;

                this.vw.mn.md = this.vw.md.cMd();
                this.vw.mn.hst.add(this.vw.mn.md);
                this.vw.cns.taa = false;
                this.dispose();
            }

            if (bP.type.equals("cancel")) {
                this.vw.md = this.vw.mn.md.cMd();
                this.vw.cns.taa = false;
                this.dispose();
            }

            if (bP.type.equals("project type")) {
                if (this.npr == 9) {
                    if (this.prt == 9) this.prt = bP.x;
                    else this.prt = 9;
                }
                else {
                    this.vw.md.nP(this.tm, this.npr, bP.x);
                    this.sp++;
                    this.npr = 9;
                }
            }

            if (bP.type.equals("new project")) {
                if (this.s2l[bP.x] == 9) {
                    if (this.prt == 9) {
                        if (this.npr == 9) this.npr = bP.x;
                        else this.npr = 9;
                    }
                    else {
                        this.vw.md.nP(this.tm, bP.x, this.prt);
                        this.sp++;
                        this.prt = 9;
                    }
                }
                else {
                    this.vw.md.ppf[this.vw.md.yr][s2l[bP.x]].prj = false;
                    if (this.vw.md.ppf[this.vw.md.yr][s2l[bP.x]].js)
                        this.sp--;
                }
            }

            if (bP.type.equals("execute project")) {
                prj = this.vw.md.ppf[this.vw.md.yr][this.s2l[bP.x]];

                prj.sts = prj.sts + bP.y + 1;
                prj.py = prj.py + bP.y + 1;
                this.vw.md.ps = this.vw.md.ps + bP.y + 1;

                this.tc = this.tc + Integer.parseInt(bP.getText());
/*
                this.vw.md.ppf[this.vw.md.yr][this.s2l[bP.x]].sts =
                    this.vw.md.ppf[this.vw.md.yr][this.s2l[bP.x]].sts + (bP.y + 1);
                this.vw.md.ps = this.vw.md.ps + bP.y + 1;
                this.vw.md.ppf[this.vw.md.yr][this.s2l[bP.x]].py =
                    this.vw.md.ppf[this.vw.md.yr][this.s2l[bP.x]].py + bP.y + 1;
*/
            }

            if (bP.type.equals("maintain project")) {
                this.vw.md.apf[this.vw.md.yr][bP.x][this.tm].mnt = true;
                this.tc = this.tc + this.vw.md.mc();
            }

            this.vw.rfr();
            this.rfr();
        }
    }

    public class SR extends JFrame { // sr = status report

        Mn mn;
        int tm;

        JLabel[][]
            hd, // hd = header
            bd; // bd = body

        public SR(Mn mn, int tm) {
            this.mn = mn;
            this.tm = tm;

            Prj[] prj = this.mn.md.ppf[this.mn.md.yr];
            Sst[][] sst = this.mn.md.apf[this.mn.md.yr];

            this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
            this.setSize(500, 400);
            this.setLocation(450, 50);
            this.setTitle("status report " + Cs.nm[this.tm]);

            Container wd = this.getContentPane();
            wd.setLayout(new GridBagLayout());
            wd.setBackground(Color.black);

            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = GridBagConstraints.BOTH;
            gc.weightx = 1;
            gc.weighty = 1;
            gc.insets = new Insets(1, 1, 1, 1);

            hd = new JLabel[2][2];
            bd = new JLabel[4][Cs.sgm + 1];

            gc.gridwidth = 2;
            for(int x = 0; x < 2; x++) {
                for(int y = 0; y < 2; y++) {
                    hd[x][y] = new JLabel();
                    hd[x][y].setOpaque(true);
                    hd[x][y].setBackground(Color.white);
                    hd[x][y].setHorizontalAlignment(JLabel.CENTER);
                    gc.gridx = 2 * x;
                    gc.gridy = y;
                    wd.add(hd[x][y], gc);
                }
            }
            hd[0][0].setText("team");
            hd[0][1].setText("year");

            hd[1][0].setText(Cs.nm[this.tm]);
            hd[1][1].setText(Integer.toString(this.mn.md.yr));
            gc.gridwidth = 1;

            for(int x = 0; x < 4; x++) {
                for(int smi = 0; smi < Cs.sgm + 1; smi++) { // smi = segment index
                    bd[x][smi] = new JLabel();
                    bd[x][smi].setOpaque(true);
                    bd[x][smi].setBackground(Color.white);
                    bd[x][smi].setHorizontalAlignment(JLabel.CENTER);
                    gc.gridx = x;
                    gc.gridy = smi + 2;
                    wd.add(bd[x][smi], gc);

                    if (smi == 0) {
                        switch(x) {
                            case 0:
                                bd[x][smi].setText("segment");
                                break;
                            case 1:
                                bd[x][smi].setText("project type");
                                break;
                            case 2:
                                bd[x][smi].setText("phases left");
                                break;
                            case 3:
                                bd[x][smi].setText("end of life");
                        }
                    }

                    if (x == 0 && smi > 0) {
                        bd[x][smi].setText(Integer.toString(smi));
                    }
                }
            }

            for(int li = 0; li < Cs.ln; li++) { // li = lane index
                if (prj[li].prj && prj[li].tm == this.tm) {
                    this.bd[1][prj[li].sgm + 1].setText(Cs.tn[prj[li].tp]);
                    this.bd[2][prj[li].sgm + 1].setText(Integer.toString(Cs.np[prj[li].tp] - prj[li].sts));
                }
            }

            for(int smi = 0; smi < Cs.sgm; smi++) { // smi = segment index
                if (sst[smi][this.tm].sst && sst[smi][this.tm].lcl == 5) {
                    this.bd[3][smi + 1].setText("x");
                }
            }

            this.setVisible(true);
        }
    }

    public class PP extends JFrame { // pp = project portfolio
        Vw vw;

        JLabel[][] pP; // pp = project portfolio

        public PP(Vw vw) {
            this.vw = vw;

            this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
            this.setSize(300, 300);
            this.setLocation(25, 250);
            this.setTitle("project portfolio");

            Container wd = this.getContentPane(); // wd = window
            wd.setLayout(new GridBagLayout());

            GridBagConstraints gc = new GridBagConstraints(); // gc = gridbagconstraints
            gc.fill = GridBagConstraints.BOTH;
            gc.weightx = 1;
            gc.weighty = 1;
            gc.insets = new Insets(3, 3, 3, 3);

            this.pP = new JLabel[Cs.ln][Cs.pp + 1];

            for(int li = 0; li < Cs.ln; li++) {
                for(int pi = 0; pi < Cs.pp + 1; pi++) {
                    this.pP[li][pi] = new JLabel("  ");
                    this.pP[li][pi].setOpaque(true);
                    this.pP[li][pi].setBackground(Color.lightGray);
                    gc.gridx = li;
                    gc.gridy = pi;
                    wd.add(pP[li][pi], gc);
                }

                this.pP[li][Cs.pp].setHorizontalAlignment(JLabel.CENTER);
            }

            this.setVisible(true);
        }

        public void rfr() { // rfr = refresh
            Prj prj;

            for(int li = 0; li < Cs.ln; li++) { // li = lane index
                prj = this.vw.md.ppf[this.vw.md.yr][li];

                if (prj.prj) {
                    for(int pi = 0; pi < Cs.sp[prj.tp]; pi++) { // pi = phase index
                        this.pP[li][pi].setBackground(Color.lightGray);
                    }
                    for(int pi = Cs.sp[prj.tp]; pi < Cs.sp[prj.tp] + prj.sts; pi++) {
                        this.pP[li][pi].setBackground(Cs.clr[prj.tm]);
                    }
                    for(int pi = Cs.sp[prj.tp] + prj.sts; pi < Cs.ep[prj.tp]; pi++) {
                        this.pP[li][pi].setBackground(Color.black);
                    }
                    for(int pi = Cs.ep[prj.tp]; pi < Cs.pp; pi++) {
                        this.pP[li][pi].setBackground(Color.lightGray);
                    }

                    this.pP[li][Cs.pp].setBackground(Cs.clr[prj.tm]);
                    this.pP[li][Cs.pp].setText(Integer.toString(prj.sgm + 1));
                }
                else {
                    for(int pi = 0; pi <= Cs.pp; pi++) {
                        this.pP[li][pi].setBackground(Color.lightGray);
                        this.pP[li][pi].setText("  ");
                    }
                }
            }
        }
    }

    public class AP extends JFrame { // ap = application portfolio

        public class SF extends Container { // sf = system field

            boolean[]
                tm, // tm = team
                mt; // mt = maintained

            JLabel[] sP; // sp = system part

            public SF() {
                this.setLayout(new GridBagLayout());
                GridBagConstraints gc = new GridBagConstraints();
                gc.fill = GridBagConstraints.BOTH;
                gc.weightx = 1;
                gc.weighty = 1;

                this.tm = new boolean[Cs.tm];
                this.mt = new boolean[Cs.tm];

                this.sP = new JLabel[Cs.sfp];

                gc.gridy = 0;
                for(int si = 0; si < Cs.sfp; si++) { // si = system part index
                    this.sP[si] = new JLabel();
                    this.sP[si].setOpaque(true);
                    gc.gridx = si;
                    this.add(sP[si], gc);
                }

                this.rst();
                this.setVisible(true);
            }

            public void rst() { // rst = reset
                for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                    this.tm[ti] = false;
                    this.mt[ti] = false;
                }

                this.rfr();
            }

            public void aT(int tm, boolean mt) { // at = add team, mt = maintained
                this.tm[tm] = true;
                this.mt[tm] = mt;

                this.rfr();
            }

            public void rfr() { // rfr = refresh
                for(int si = 0; si < Cs.sfp; si++) { // si = system index
                    this.sP[si].setBackground(Color.lightGray);
                }

                int nt = 0; // nt = number of teams

                for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                    if (this.tm[ti]) {
                        nt++;
                    }
                }

                int tn = 0; // tn = team number

                for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                    if (this.tm[ti]) {
                        for(int sfi = tn * Cs.sfp / nt; sfi < (tn + 1) * Cs.sfp / nt; sfi++) { // sfi = system field index
                            sP[sfi].setBackground(Cs.clr[ti]);
                        }

                        if (this.mt[ti]) {
                            for(int si = tn * Cs.sfp / nt + (Cs.sfp / 3) / nt; si < (tn + 1) * Cs.sfp / nt - (Cs.sfp / 3) / nt; si++) {
                                sP[si].setBackground(Color.white);
                            }
                        }

                        tn++;
                    }
                }
            }
        }

        Vw vw;

        JLabel[] hR, vR; // hr, vr = horizontal, vertical rule

        SF[][] sF; // sf = system field

        public AP(Vw vw) {
            this.vw = vw;

            this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
            this.setSize(300, 300);
            this.setLocation(350, 250);
            this.setTitle("application portfolio");

            Container wd = this.getContentPane();
            wd.setLayout(new GridBagLayout());

            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = GridBagConstraints.BOTH;
            gc.weightx = 1;
            gc.weighty = 1;
            gc.ipadx = 5;
            gc.ipady = 5;
            gc.insets = new Insets(1, 1, 1, 1);

            this.sF = new SF[Cs.apc][Cs.apr];

            for(int smi = 0; smi < Cs.apc; smi++) { // smi = segment and mover index
                for(int sci = 0; sci < Cs.apr; sci++) { // sci = segment and cycle index
                    this.sF[smi][sci] = new SF();
                    gc.gridx = smi + smi / Cs.mm;
                    gc.gridy = sci + sci / Cs.lcl;
                    wd.add(this.sF[smi][sci], gc);
                }
            }

            this.vR = new JLabel[2];

            gc.gridheight = 35;
            gc.weightx = 0;
            gc.gridy = 0;

            for(int vri = 0; vri < 2; vri++) { // vri = vertical rule index
                this.vR[vri] = new JLabel();
                this.vR[vri].setOpaque(true);
                this.vR[vri].setBackground(Color.black);
                gc.gridx = (vri + 1) * 4 - 1;
                wd.add(this.vR[vri], gc);
            }

            gc.gridheight = 1;
            gc.weightx = 1;

            this.hR = new JLabel[5];

            gc.gridwidth = 11;
            gc.weighty = 0;

            for(int hri = 0; hri < 5; hri++) { // hri = horizontal rule index
                this.hR[hri] = new JLabel();
                this.hR[hri].setOpaque(true);
                if (hri % 2 == 0) {
                    this.hR[hri].setBackground(Color.white);
                }
                else {
                    this.hR[hri].setBackground(Color.black);
                }
                gc.gridx = 0;
                gc.gridy = (hri + 1) * 6 - 1;
                wd.add(this.hR[hri], gc);
            }

            gc.gridwidth = 1;
            gc.weighty = 1;

            this.setVisible(true);
        }

        public void rfr() { // rfr = refresh
            Sst[] sst; // sst = system
            int[] by; // by = building year
            int[] mb; // mv = mover order of building year
            int tby; // tby = temporary building year
            int bi; // bi = bubble index
            int tm; // tm = team index
            int mo; // mo = mover order
            int ci; // ci = column index
            int ri; // ri = row index

            for(int cli = 0; cli < Cs.apc; cli++) { // cli = column index
                for(int rwi = 0; rwi < Cs.apr; rwi++) { // rwi = row index
                    sF[cli][rwi].rst();
                }
            }

            for(int si = 0; si < Cs.sgm; si++) { // si = segment index
                sst = this.vw.md.apf[this.vw.md.yr][si];
                by = new int[Cs.tm];
                mb = new int[Cs.al];

                for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                    if (sst[ti].sst) by[ti] = sst[ti].by + 5;
                    else by[ti] = Cs.al;
                }

                for(int ti = 1; ti < Cs.tm; ti++) {
                    bi = ti;

                    while (bi > 0 && by[bi - 1] > by[bi]) {
                        tby = by[bi];
                        by[bi] = by[bi - 1];
                        by[bi - 1] = tby;
                        bi--;
                    }
                }

                mo = 0;
                for(int tmi = 0; tmi < Cs.tm; tmi++) {
                    if (by[tmi] < Cs.al && (tmi == 0 || by[tmi - 1] != by[tmi])) {
                        mb[by[tmi]] = mo;
                        mo++;
                    }
                }

                for(int ti = 0; ti < Cs.tm; ti++) {
                    if (sst[ti].sst) {
                        ci = 3 * (si % 3) + mb[sst[ti].by + 5];
                        ri = 10 * (si / 3) + sst[ti].lcl - 1;
                        if (sst[ti].arc) ri = ri + 5;
                        this.sF[ci][ri].aT(ti, sst[ti].mnt);
                    }
                }
            }
        }
    }

    Mn mn;
    Md md;

    Cns cns;
    PP ppf;
    AP apf;

    public Vw(Mn mn) {
        this.mn = mn;

        this.cns = new Cns(this);
        this.ppf = new PP(this);
        this.apf = new AP(this);
    }

    public void rfr() { // rfr = refresh
        this.cns.rfr();
        this.ppf.rfr();
        this.apf.rfr();
    }
}