package gg7;

// this model contains both the state at the beginning of each year
// aswell as the mutations done during a year:
// for projects that is py
// for applications that is mnt
// for the model that is sp and ps

public class Md { // md = model

    public class Prj { // prj = project
        boolean prj, js;
        int tm, sgm, tp, sts, py;

// prj = project or not
// js = just started
// tm = team 0 - (Cs.teams - 1)
// sgm = segment 0 - (Cs.segments - 1)
// tp = type of project
//     0 = defensive
//     1 = offensive
//     2 = anticipative
//     3 = migration
//     4 = renewal
// sts = status, no of phases done
// py = no of phases done this year

        public Prj cp() { // cp = copy
            Prj cp = new Prj();

            cp.prj = this.prj;
            cp.tm = this.tm;
            cp.sgm = this.sgm;
            cp.tp = this.tp;
            cp.sts = this.sts;
            cp.py = this.py;

            return cp;
        }
    }

    public class Sst { // sst = system
        boolean sst, arc, mnt;
        int by, lcl;

// sst = system or not
// arc = built under architecture or not
// mnt = maintained or not
// by = building year
// lcl = life cycle 1 - 5

        public Sst cp() { // cp = copy
            Sst cp = new Sst();

            cp.sst = this.sst;
            cp.arc = this.arc;
            cp.mnt = this.mnt;
            cp.by  = this.by;
            cp.lcl = this.lcl;

            return cp;
        }
    }

    int
        yr, // yr = year
        sp, // sp = no of started projects this year
        ps; // ps = no of project steps taken this year

// the variable b2p is a little model that keeps track of going backward:
// at the beginning of a year bw goes back to the beginning of the previous year
// during a year bw goes back to the beginning of this year
    boolean b2p; // b2p = backward to previous year

    Prj[][] ppf; // ppf = project portfolio [year][lane]
    Sst[][][] apf; // apf = application portfolio [year][segment][team]

    public Md() {
        this.ppf = new Prj[Cs.al][Cs.ln];
        this.apf = new Sst[Cs.al][Cs.sgm][Cs.tm];

        for(int yr = 0; yr < Cs.al; yr++) { // yr = year
            for(int li = 0; li < Cs.ln; li++) { // li = lane index
                this.ppf[yr][li] = new Prj();
                this.ppf[yr][li].prj = false;
            }

            for(int smi = 0; smi < Cs.sgm; smi++) { // si = segment index
                for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                    this.apf[yr][smi][ti] = new Sst();
                    this.apf[yr][smi][ti].sst = false;
                }
            }
        }
    }

    public void init() {
        this.yr = 0;
        this.sp = 0;
        this.ps = 0;
        this.b2p = true;

        this.iP();
        this.nY(0);
        this.yr++;
    }

    public void iP() { // ip = initial position
        this.ppf[0][this.nP(0, 8, 0)].sts = 2;

        this.nS(0, 0, true);
        this.apf[0][0][0].by = -3;
        this.apf[0][0][0].lcl = 2;
        this.nS(2, 0, true);
        this.apf[0][2][0].by = -1;
        this.apf[0][2][0].lcl = 3;
        this.nS(6, 0, true);
        this.apf[0][6][0].by = -2;
        this.apf[0][6][0].lcl = 4;

        this.ppf[0][this.nP(1, 4, 1)].sts = 2;

        this.nS(1, 1, true);
        this.apf[0][1][1].by = -3;
        this.apf[0][1][1].lcl = 3;
        this.nS(2, 1, true);
        this.apf[0][2][1].by = -2;
        this.apf[0][2][1].lcl = 4;
        this.nS(6, 1, true);
        this.apf[0][6][1].by = -3;
        this.apf[0][6][1].lcl = 2;

        this.ppf[0][this.nP(2, 1, 2)].sts = 4;

        this.nS(4, 2, true);
        this.apf[0][4][2].by = -2;
        this.apf[0][4][2].lcl = 4;
        this.nS(6, 2, true);
        this.apf[0][6][2].by = -1;
        this.apf[0][6][2].lcl = 3;
        this.nS(8, 2, true);
        this.apf[0][8][2].by = -2;
        this.apf[0][8][2].lcl = 2;

        this.ppf[0][this.nP(3, 0, 2)].sts = 2;

        this.nS(1, 3, false);
        this.apf[0][1][3].by = -2;
        this.apf[0][1][3].lcl = 2;
        this.nS(2, 3, true);
        this.apf[0][2][3].by = -3;
        this.apf[0][2][3].lcl = 4;
        this.nS(4, 3, false);
        this.apf[0][4][3].by = -3;
        this.apf[0][4][3].lcl = 3;
    }

    public int nP(int tm, int sgm, int tp) { // np = new project
        int li = this.ffl(); // li = lane index

        this.ppf[this.yr][li].prj = true;
        this.ppf[this.yr][li].js = true;
        this.ppf[this.yr][li].tm = tm;
        this.ppf[this.yr][li].sgm = sgm;
        this.ppf[this.yr][li].tp = tp;
        this.ppf[this.yr][li].sts = 0;
        this.ppf[this.yr][li].py = 0;

        return li;
    }

    public void nS(int sgm, int tm, boolean arc) { // ns = new system
            this.apf[this.yr][sgm][tm].sst = true;
            this.apf[this.yr][sgm][tm].by = this.yr;
            this.apf[this.yr][sgm][tm].arc = arc;
            this.apf[this.yr][sgm][tm].mnt = false;
            this.apf[this.yr][sgm][tm].lcl = 1;
    }

    public Prj[][] cPP() { // cpp = copy project portfolio
        Prj[][] cp = new Prj[Cs.al][Cs.ln];

        for(int yr = 0; yr < Cs.al; yr++) { // yr = year
            for(int li = 0; li < Cs.ln; li++) { // li = lane index
                cp[yr][li] = this.ppf[yr][li].cp();
            }
        }

        return cp;
    }

    public Sst[][][] cAP() { // cap = copy application portfolio
        Sst[][][] cp = new Sst[Cs.al][Cs.sgm][Cs.tm];

        for(int yr = 0; yr < Cs.al; yr++) { // yr = year
            for(int smi = 0; smi < Cs.sgm; smi++) { // si = segment index
                for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                    cp[yr][smi][ti] = this.apf[yr][smi][ti].cp();
                }
            }
        }

        return cp;
    }

    public Md cMd() { // cmd = copy model
        Md cp = new Md();

        cp.yr = this.yr;
        cp.ps = this.ps;
        cp.sp = this.sp;
        cp.b2p = this.b2p;

        cp.apf = this.cAP();
        cp.ppf = this.cPP();

        return cp;
    }

    public void nY(int yr) { // nY = next year
        for(int li = 0; li < Cs.ln; li++) // li = lane index
            this.ppf[yr + 1][li] = this.ppf[yr][li].cp();

        for(int smi = 0; smi < Cs.sgm; smi++) // smi = segment index
            for(int ti = 0; ti < Cs.tm; ti++) // ti = team index
                this.apf[yr + 1][smi][ti] = this.apf[yr][smi][ti].cp();
    }

    public int ffl() { // ffl = first free lane
        int li = 0; // li = lane index

        while (li < Cs.ln && this.ppf[this.yr][li].prj) {
            li++;
        }

        return li;
    }

    public int mc() { // mc = maintenance costs
        int sna = 0; // sna = systems not under architecture
        Sst sst;

// count number of systems not under architecture
        for(int smi = 0; smi < Cs.sgm; smi++) { // sgi = segment index
            for(int ti = 0; ti < Cs.tm; ti++) { // ti = team index
                sst = this.apf[this.yr][smi][ti];
                if (sst.sst && !sst.arc) sna++;
            }
        }

        return 1 + (sna - 1) / Cs.ms;
    }

    public boolean nSP(int sgm) { // nsp = new system possible
        Sst[] sst = this.apf[this.yr][sgm];

        int ns = 0; // ns = no of systems

        for(int tmi = 0; tmi < Cs.tm; tmi++) // tmi = team index
            if (sst[tmi].sst) ns++;

        if (ns < Cs.mm) return true;
        else return false;
    }

    public int[] to(int sgm) { // to = turnover [team]
        Sst[] sst = this.apf[this.yr][sgm];

        int mno; // mno = mover number

        int[] nap = new int[Cs.al + 5]; // nap = no of applications [building year]
        int[] mi = new int[Cs.al + 5]; // mi = mover index [building year]:
        int[] nt = new int[Cs.mm]; // nt = no of teams [mover index]
        int[] to = new int[Cs.tm]; // to = turnover [team]

        for(int by = 0; by < Cs.al + 5; by++) // by = building year
            nap[by] = 0;

        for(int mii = 0; mii < Cs.al + 5; mii++) // mii = mover index
            mi[mii] = 0;

        for(int nti = 0; nti < Cs.mm; nti++) // nti = no of teams index
            nt[nti] = 0;

        for(int tmi = 0; tmi < Cs.tm; tmi++) // tmi = team index
            to[tmi] = 0;

        for(int ti = 0; ti < Cs.tm; ti++) // ti = team index
            if (sst[ti].sst) nap[sst[ti].by + 5]++;

        mno = 0;
        for(int by = 0; by < Cs.al + 5; by++) { // by = building year
            if (nap[by] > 0) {
                mi[by] = mno; // applications of building year by have mover index mno
                nt[mno] = nap[by]; // there are nap[by] teams with mover index mno
                mno++;
            }
        }

        for(int tmi = 0; tmi < Cs.tm; tmi++) { // tmi = team index
            if (sst[tmi].sst) to[tmi] = Cs.to[nt[0]][nt[1]][nt[2]][mi[sst[tmi].by + 5]];
        }

        return to;
    }
}