/*
 * Decompiled with CFR 0.152.
 */
package gg7;

import gg7.Constants;

public class Model {
    int yr;
    int sp;
    int ps;
    boolean b2p;
    Project[][] ppf = new Project[100][6];
    System[][][] apf = new System[100][9][Constants.tm];

    public Model() {
        for (int yr = 0; yr < 100; ++yr) {
            for (int li = 0; li < 6; ++li) {
                this.ppf[yr][li] = new Project();
                this.ppf[yr][li].prj = false;
            }
            for (int smi = 0; smi < 9; ++smi) {
                for (int ti = 0; ti < Constants.tm; ++ti) {
                    this.apf[yr][smi][ti] = new System();
                    this.apf[yr][smi][ti].system = false;
                }
            }
        }
    }

    public void init() {
        this.yr = 0;
        this.sp = 0;
        this.ps = 0;
        this.b2p = true;
        this.iP();
        this.nY(0);
        ++this.yr;
    }

    public void iP() {
        switch (Constants.tm) {
            default: {
                this.ppf[0][this.nP((int)0, (int)8, (int)0)].sts = 2;
                this.newSystem(0, 0, true);
                this.apf[0][0][0].buildYear = -3;
                this.apf[0][0][0].lifeCycle = 2;
                this.newSystem(2, 0, true);
                this.apf[0][2][0].buildYear = -1;
                this.apf[0][2][0].lifeCycle = 3;
                this.newSystem(6, 0, true);
                this.apf[0][6][0].buildYear = -2;
                this.apf[0][6][0].lifeCycle = 4;
                this.ppf[0][this.nP((int)1, (int)4, (int)1)].sts = 2;
                this.newSystem(1, 1, true);
                this.apf[0][1][1].buildYear = -3;
                this.apf[0][1][1].lifeCycle = 3;
                this.newSystem(2, 1, true);
                this.apf[0][2][1].buildYear = -2;
                this.apf[0][2][1].lifeCycle = 4;
                this.newSystem(6, 1, true);
                this.apf[0][6][1].buildYear = -3;
                this.apf[0][6][1].lifeCycle = 2;
                this.ppf[0][this.nP((int)2, (int)1, (int)2)].sts = 4;
                this.newSystem(4, 2, true);
                this.apf[0][4][2].buildYear = -2;
                this.apf[0][4][2].lifeCycle = 4;
                this.newSystem(6, 2, true);
                this.apf[0][6][2].buildYear = -1;
                this.apf[0][6][2].lifeCycle = 3;
                this.newSystem(8, 2, true);
                this.apf[0][8][2].buildYear = -2;
                this.apf[0][8][2].lifeCycle = 2;
                this.ppf[0][this.nP((int)3, (int)0, (int)2)].sts = 2;
                this.newSystem(1, 3, false);
                this.apf[0][1][3].buildYear = -2;
                this.apf[0][1][3].lifeCycle = 2;
                this.newSystem(2, 3, true);
                this.apf[0][2][3].buildYear = -3;
                this.apf[0][2][3].lifeCycle = 4;
                this.newSystem(4, 3, false);
                this.apf[0][4][3].buildYear = -3;
                this.apf[0][4][3].lifeCycle = 3;
                break;
            }
            case 3: {
                this.ppf[0][this.nP((int)0, (int)8, (int)0)].sts = 2;
                this.newSystem(0, 0, true);
                this.apf[0][0][0].buildYear = -1;
                this.apf[0][0][0].lifeCycle = 2;
                this.newSystem(2, 0, true);
                this.apf[0][2][0].buildYear = -1;
                this.apf[0][2][0].lifeCycle = 3;
                this.newSystem(7, 0, true);
                this.apf[0][7][0].buildYear = -1;
                this.apf[0][7][0].lifeCycle = 4;
                this.newSystem(6, 0, false);
                this.apf[0][6][0].buildYear = -3;
                this.apf[0][6][0].lifeCycle = 4;
                this.ppf[0][this.nP((int)1, (int)4, (int)1)].sts = 2;
                this.newSystem(2, 1, false);
                this.apf[0][2][1].buildYear = -2;
                this.apf[0][2][1].lifeCycle = 4;
                this.newSystem(6, 1, false);
                this.apf[0][6][1].buildYear = -2;
                this.apf[0][6][1].lifeCycle = 2;
                this.newSystem(7, 1, true);
                this.apf[0][7][1].buildYear = -3;
                this.apf[0][7][1].lifeCycle = 3;
                this.newSystem(8, 1, true);
                this.apf[0][8][1].buildYear = -3;
                this.apf[0][8][1].lifeCycle = 2;
                this.ppf[0][this.nP((int)2, (int)1, (int)2)].sts = 4;
                this.newSystem(2, 2, true);
                this.apf[0][2][2].buildYear = -3;
                this.apf[0][2][2].lifeCycle = 4;
                this.newSystem(4, 2, true);
                this.apf[0][4][2].buildYear = -2;
                this.apf[0][4][2].lifeCycle = 2;
                this.newSystem(6, 2, true);
                this.apf[0][6][2].buildYear = -1;
                this.apf[0][6][2].lifeCycle = 3;
                this.newSystem(8, 2, true);
                this.apf[0][8][2].buildYear = -2;
                this.apf[0][8][2].lifeCycle = 2;
                break;
            }
            case 2: {
                this.ppf[0][this.nP((int)0, (int)3, (int)1)].sts = 1;
                this.ppf[0][this.nP((int)0, (int)5, (int)1)].sts = 3;
                this.newSystem(0, 0, true);
                this.apf[0][0][0].buildYear = -3;
                this.apf[0][0][0].lifeCycle = 2;
                this.newSystem(2, 0, true);
                this.apf[0][2][0].buildYear = -2;
                this.apf[0][2][0].lifeCycle = 3;
                this.newSystem(4, 0, false);
                this.apf[0][4][0].buildYear = -2;
                this.apf[0][4][0].lifeCycle = 4;
                this.newSystem(6, 0, false);
                this.apf[0][6][0].buildYear = -3;
                this.apf[0][6][0].lifeCycle = 2;
                this.ppf[0][this.nP((int)1, (int)4, (int)0)].sts = 1;
                this.ppf[0][this.nP((int)1, (int)7, (int)2)].sts = 2;
                this.newSystem(1, 1, true);
                this.apf[0][1][1].buildYear = -3;
                this.apf[0][1][1].lifeCycle = 3;
                this.newSystem(2, 1, false);
                this.apf[0][2][1].buildYear = -1;
                this.apf[0][2][1].lifeCycle = 4;
                this.newSystem(4, 1, false);
                this.apf[0][4][1].buildYear = -3;
                this.apf[0][4][1].lifeCycle = 2;
                this.newSystem(8, 1, true);
                this.apf[0][8][1].buildYear = -2;
                this.apf[0][8][1].lifeCycle = 4;
            }
        }
    }

    public int nP(int tm, int sgm, int tp) {
        int li = this.ffl();
        this.ppf[this.yr][li].prj = true;
        this.ppf[this.yr][li].js = true;
        this.ppf[this.yr][li].tm = tm;
        this.ppf[this.yr][li].sgm = sgm;
        this.ppf[this.yr][li].tp = tp;
        this.ppf[this.yr][li].sts = 0;
        this.ppf[this.yr][li].py = 0;
        return li;
    }

    public void newSystem(int sgm, int tm, boolean arc) {
        this.apf[this.yr][sgm][tm].system = true;
        this.apf[this.yr][sgm][tm].buildYear = this.yr;
        this.apf[this.yr][sgm][tm].architecture = arc;
        this.apf[this.yr][sgm][tm].maintained = false;
        this.apf[this.yr][sgm][tm].lifeCycle = 1;
    }

    public Project[][] cPP() {
        Project[][] cp = new Project[100][6];
        for (int yr = 0; yr < 100; ++yr) {
            for (int li = 0; li < 6; ++li) {
                cp[yr][li] = this.ppf[yr][li].copy();
            }
        }
        return cp;
    }

    public System[][][] cAP() {
        System[][][] cp = new System[100][9][Constants.tm];
        for (int yr = 0; yr < 100; ++yr) {
            for (int smi = 0; smi < 9; ++smi) {
                for (int ti = 0; ti < Constants.tm; ++ti) {
                    cp[yr][smi][ti] = this.apf[yr][smi][ti].copy();
                }
            }
        }
        return cp;
    }

    public Model cMd() {
        Model cp = new Model();
        cp.yr = this.yr;
        cp.ps = this.ps;
        cp.sp = this.sp;
        cp.b2p = this.b2p;
        cp.apf = this.cAP();
        cp.ppf = this.cPP();
        return cp;
    }

    public void nY(int yr) {
        for (int li = 0; li < 6; ++li) {
            this.ppf[yr + 1][li] = this.ppf[yr][li].copy();
        }
        for (int smi = 0; smi < 9; ++smi) {
            for (int ti = 0; ti < Constants.tm; ++ti) {
                this.apf[yr + 1][smi][ti] = this.apf[yr][smi][ti].copy();
            }
        }
    }

    public int ffl() {
        int li;
        for (li = 0; li < 6 && this.ppf[this.yr][li].prj; ++li) {
        }
        return li;
    }

    public int mc() {
        int sna = 0;
        for (int smi = 0; smi < 9; ++smi) {
            for (int ti = 0; ti < Constants.tm; ++ti) {
                System sst = this.apf[this.yr][smi][ti];
                if (!sst.system || sst.architecture) continue;
                ++sna;
            }
        }
        return 1 + (sna - 1) / Constants.ms;
    }

    public boolean nSP(int sgm) {
        System[] sst = this.apf[this.yr][sgm];
        int ns = 0;
        for (int tmi = 0; tmi < Constants.tm; ++tmi) {
            if (!sst[tmi].system) continue;
            ++ns;
        }
        return ns < 3;
    }

    public int[] to(int sgm) {
        int tmi;
        int by;
        System[] sst = this.apf[this.yr][sgm];
        int[] nap = new int[105];
        int[] mi = new int[105];
        int[] nt = new int[3];
        int[] to = new int[Constants.tm];
        for (by = 0; by < 105; ++by) {
            nap[by] = 0;
        }
        for (int mii = 0; mii < 105; ++mii) {
            mi[mii] = 0;
        }
        for (int nti = 0; nti < 3; ++nti) {
            nt[nti] = 0;
        }
        for (tmi = 0; tmi < Constants.tm; ++tmi) {
            to[tmi] = 0;
        }
        for (int ti = 0; ti < Constants.tm; ++ti) {
            if (!sst[ti].system) continue;
            int n = sst[ti].buildYear + 5;
            nap[n] = nap[n] + 1;
        }
        int mno = 0;
        for (by = 0; by < 105; ++by) {
            if (nap[by] <= 0) continue;
            mi[by] = mno;
            nt[mno] = nap[by];
            ++mno;
        }
        for (tmi = 0; tmi < Constants.tm; ++tmi) {
            if (!sst[tmi].system) continue;
            to[tmi] = Constants.to[nt[0]][nt[1]][nt[2]][mi[sst[tmi].buildYear + 5]];
        }
        return to;
    }

    public class System {
        boolean system;
        boolean architecture;
        boolean maintained;
        int buildYear;
        int lifeCycle;

        public System copy() {
            System cp = new System();
            cp.system = this.system;
            cp.architecture = this.architecture;
            cp.maintained = this.maintained;
            cp.buildYear = this.buildYear;
            cp.lifeCycle = this.lifeCycle;
            return cp;
        }
    }

    public class Project {
        boolean prj;
        boolean js;
        int tm;
        int sgm;
        int tp;
        int sts;
        int py;

        public Project copy() {
            Project cp = new Project();
            cp.prj = this.prj;
            cp.tm = this.tm;
            cp.sgm = this.sgm;
            cp.tp = this.tp;
            cp.sts = this.sts;
            cp.py = this.py;
            return cp;
        }
    }
}

