/*
 * Decompiled with CFR 0.152.
 */
package gg7;

import gg7.Constants;
import gg7.History;
import gg7.Model;
import gg7.Viewer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Main
extends JFrame {
    Model md;
    History hst;
    private final int MAX_TEAMS = 4;
    private JPanel pnlMain;
    private JComboBox cbTeams;
    private JComboBox cbMF;
    private JLabel[] lblTeamName;
    private JTextField[] tfTeamName;
    private JPanel[] pnlTeamColor;

    public static void main(String[] args) {
        new Main();
    }

    public Main() {
        this.createInterface();
    }

    private void createInterface() {
        this.setDefaultCloseOperation(3);
        this.setSize(480, 200);
        this.setLocation(25, 25);
        this.setTitle("IT Governance Game (Offline)");
        this.setResizable(false);
        this.setLayout(null);
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(null);
        this.pnlMain.setBounds(0, 0, this.getSize().width, this.getSize().height);
        this.updateInterface();
        this.add(this.pnlMain);
        this.setVisible(true);
    }

    private void updateInterface() {
        JPanel pnlSettings = new JPanel();
        pnlSettings.setLayout(null);
        pnlSettings.setBounds(10, 10, 235, 150);
        pnlSettings.setBorder(BorderFactory.createTitledBorder("Settings"));
        JLabel lblTeamSettings = new JLabel("No. of Teams:");
        lblTeamSettings.setBounds(15, 20, 85, 25);
        this.cbTeams = new JComboBox<Integer>(new Integer[]{2, 3, 4});
        this.cbTeams.setBounds(lblTeamSettings.getBounds().x + lblTeamSettings.getBounds().width + 45, lblTeamSettings.getBounds().y, 75, 25);
        this.cbTeams.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.onChangeTeams();
            }
        });
        JLabel lblMF = new JLabel("Maintenance Factor:");
        lblMF.setBounds(lblTeamSettings.getBounds().x, lblTeamSettings.getBounds().y + lblTeamSettings.getBounds().height + 5, 125, 25);
        this.cbMF = new JComboBox<String>(new String[]{"Total", "Total / 2"});
        this.cbMF.setBounds(lblMF.getBounds().x + lblMF.getBounds().width + 5, lblMF.getBounds().y, 75, 25);
        JLabel lblSkip1stFase = new JLabel("Skip first fase?");
        lblSkip1stFase.setBounds(lblMF.getBounds().x, lblMF.getBounds().y + lblMF.getBounds().height + 5, 125, 25);
        JCheckBox tbSkip1stFase = new JCheckBox();
        tbSkip1stFase.setBounds(lblSkip1stFase.getBounds().width + 15, lblSkip1stFase.getBounds().y, 25, 25);
        JPanel pnlTeams = new JPanel();
        pnlTeams.setLayout(null);
        pnlTeams.setBounds(pnlSettings.getBounds().x + pnlSettings.getBounds().width + 10, pnlSettings.getBounds().y, 205, 150);
        pnlTeams.setBorder(BorderFactory.createTitledBorder("Team Names"));
        this.lblTeamName = new JLabel[4];
        this.tfTeamName = new JTextField[4];
        this.pnlTeamColor = new JPanel[4];
        for (int i = 0; i < 4; ++i) {
            this.lblTeamName[i] = new JLabel("Team " + (i + 1) + ":");
            this.lblTeamName[i].setBounds(15, 20 + i * 30, 85, 25);
            this.tfTeamName[i] = new JTextField("Team " + (i + 1));
            this.tfTeamName[i].setBounds(70, 20 + i * 30, 85, 25);
            this.pnlTeamColor[i] = new JPanel();
            this.pnlTeamColor[i].setBounds(165, 20 + i * 30, 25, 25);
            switch (i) {
                case 0: {
                    this.tfTeamName[i].setText("Red");
                    this.pnlTeamColor[i].setBackground(Color.red);
                    break;
                }
                case 1: {
                    this.tfTeamName[i].setText("Yellow");
                    this.pnlTeamColor[i].setBackground(Color.yellow);
                    break;
                }
                case 2: {
                    this.tfTeamName[i].setText("Green");
                    this.pnlTeamColor[i].setBackground(Color.green);
                    break;
                }
                case 3: {
                    this.tfTeamName[i].setText("Blue");
                    this.pnlTeamColor[i].setBackground(Color.blue);
                }
            }
            pnlTeams.add(this.lblTeamName[i]);
            pnlTeams.add(this.tfTeamName[i]);
            pnlTeams.add(this.pnlTeamColor[i]);
        }
        this.onChangeTeams();
        JButton cmdDefault = new JButton("Default");
        cmdDefault.setBounds(lblSkip1stFase.getBounds().x, lblSkip1stFase.getBounds().y + lblSkip1stFase.getBounds().height + 5, 98, 25);
        cmdDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.onDefault();
            }
        });
        JButton cmdStart = new JButton("Start Game");
        cmdStart.setBounds(cmdDefault.getBounds().x + cmdDefault.getBounds().width + 10, lblSkip1stFase.getBounds().y + lblSkip1stFase.getBounds().height + 5, 98, 25);
        cmdStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.onStart();
            }
        });
        this.pnlMain.add(pnlSettings);
        pnlSettings.add(lblTeamSettings);
        pnlSettings.add(this.cbTeams);
        pnlSettings.add(lblMF);
        pnlSettings.add(this.cbMF);
        pnlSettings.add(cmdDefault);
        pnlSettings.add(cmdStart);
        this.pnlMain.add(pnlTeams);
        this.cbTeams.setSelectedIndex(2);
        this.cbMF.setSelectedIndex(0);
    }

    private void onChangeTeams() {
        int i;
        int numteams = (Integer)this.cbTeams.getSelectedItem();
        for (i = 0; i < numteams; ++i) {
            this.lblTeamName[i].setEnabled(true);
            this.tfTeamName[i].setEnabled(true);
            this.pnlTeamColor[i].setVisible(true);
        }
        for (i = numteams; i < 4; ++i) {
            this.lblTeamName[i].setEnabled(false);
            this.tfTeamName[i].setEnabled(false);
            this.pnlTeamColor[i].setVisible(false);
        }
    }

    private void onDefault() {
        int bIsSure = JOptionPane.showConfirmDialog(null, "Are you sure you wish the reset all settings to their default value?", "Reset to default settings", 0);
        if (bIsSure == 0) {
            this.pnlMain.removeAll();
            this.updateInterface();
            this.repaint();
        }
    }

    private void onStart() {
        this.setVisible(false);
        Constants.tm = (Integer)this.cbTeams.getSelectedItem();
        Constants.ms = this.cbMF.getSelectedIndex() + 1;
        this.md = new Model();
        this.md.init();
        Viewer vw = new Viewer(this);
        this.hst = new History(this.md.cMd());
        vw.md = this.md.cMd();
        vw.rfr();
    }
}

