/*
 * Decompiled with CFR 0.152.
 */
package v1.Views;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import v1.Controllers.ViewController;
import v1.Factories.FunctionFactory;
import v1.Models.Team;
import v1.Views.MainView;

public class View_Startup
extends MainView {
    private ViewController viewController;
    private int MIN_TEAMS;
    private int MAX_TEAMS;
    private int NUM_TEAMS;
    private JPanel pnlMain;
    private JComboBox cbTeams;
    private JLabel[] lblTeamName;
    private JTextField[] tfTeamName;
    private JPanel[] pnlTeamColor;

    public View_Startup(ViewController viewController) {
        this.viewController = viewController;
        this.MIN_TEAMS = (Integer)viewController.getGameSettings().getSetting("MIN_TEAMS");
        this.MAX_TEAMS = (Integer)viewController.getGameSettings().getSetting("MAX_TEAMS");
        this.NUM_TEAMS = this.MIN_TEAMS;
        this.createInterface();
    }

    private void createInterface() {
        this.setDefaultCloseOperation(0);
        this.setSize(490, 200);
        this.setLocation(25, 25);
        this.setTitle("IT Governance Game (Offline)");
        this.setResizable(false);
        this.setLayout(null);
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(null);
        this.pnlMain.setBounds(0, 0, this.getSize().width, this.getSize().height);
        this.updateInterface();
        this.add(this.pnlMain);
        this.setVisible(true);
    }

    private void updateInterface() {
        JPanel pnlSettings = new JPanel();
        pnlSettings.setLayout(null);
        pnlSettings.setBounds(10, 10, 235, 150);
        pnlSettings.setBorder(BorderFactory.createTitledBorder("Settings"));
        JLabel lblTeamSettings = new JLabel("No. of Teams:");
        lblTeamSettings.setBounds(15, 20, 85, 25);
        Integer[] lstTeams = new Integer[this.MAX_TEAMS - this.MIN_TEAMS + 1];
        for (int i = 0; i < lstTeams.length; ++i) {
            lstTeams[i] = this.MIN_TEAMS + i;
        }
        this.cbTeams = new JComboBox<Integer>(lstTeams);
        this.cbTeams.setBounds(lblTeamSettings.getBounds().x + lblTeamSettings.getBounds().width + 45, lblTeamSettings.getBounds().y, 75, 25);
        this.cbTeams.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                View_Startup.this.onChangeTeams();
            }
        });
        JLabel lblMF = new JLabel("Maintenance Factor:");
        lblMF.setBounds(lblTeamSettings.getBounds().x, lblTeamSettings.getBounds().y + lblTeamSettings.getBounds().height + 5, 125, 25);
        JComboBox<String> cbMF = new JComboBox<String>(new String[]{"Total", "Total * 2"});
        cbMF.setBounds(lblMF.getBounds().x + lblMF.getBounds().width + 5, lblMF.getBounds().y, 75, 25);
        JLabel lblSkip1stFase = new JLabel("Skip first fase?");
        lblSkip1stFase.setBounds(lblMF.getBounds().x, lblMF.getBounds().y + lblMF.getBounds().height + 5, 125, 25);
        JCheckBox tbSkip1stFase = new JCheckBox();
        tbSkip1stFase.setBounds(lblSkip1stFase.getBounds().width + 15, lblSkip1stFase.getBounds().y, 25, 25);
        JPanel pnlTeams = new JPanel();
        pnlTeams.setLayout(null);
        pnlTeams.setBounds(0, 0, 190, 150);
        this.lblTeamName = new JLabel[this.MAX_TEAMS];
        this.tfTeamName = new JTextField[this.MAX_TEAMS];
        this.pnlTeamColor = new JPanel[this.MAX_TEAMS];
        for (int i = 0; i < this.MAX_TEAMS; ++i) {
            this.lblTeamName[i] = new JLabel("Team " + (i + 1) + ":");
            this.lblTeamName[i].setBounds(10, i * 30, 85, 25);
            this.tfTeamName[i] = new JTextField("Team " + (i + 1));
            this.tfTeamName[i].setBounds(65, i * 30, 85, 25);
            this.pnlTeamColor[i] = new JPanel();
            this.pnlTeamColor[i].setBounds(160, i * 30, 25, 25);
            this.pnlTeamColor[i].setBackground(FunctionFactory.randomColor());
            pnlTeams.add(this.lblTeamName[i]);
            pnlTeams.add(this.tfTeamName[i]);
            pnlTeams.add(this.pnlTeamColor[i]);
            pnlTeams.setPreferredSize(new Dimension(190, i * 30 + 30));
        }
        this.onChangeTeams();
        JScrollPane scrollTeams = new JScrollPane(pnlTeams);
        scrollTeams.setBounds(pnlSettings.getBounds().x + pnlSettings.getBounds().width + 10, pnlSettings.getBounds().y, 220, 150);
        scrollTeams.setBorder(BorderFactory.createTitledBorder("Team Names"));
        scrollTeams.setVerticalScrollBarPolicy(22);
        JButton cmdDefault = new JButton("Default");
        cmdDefault.setBounds(lblSkip1stFase.getBounds().x, lblSkip1stFase.getBounds().y + lblSkip1stFase.getBounds().height + 5, 98, 25);
        cmdDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                View_Startup.this.onDefault();
            }
        });
        JButton cmdStart = new JButton("Start Game");
        cmdStart.setBounds(cmdDefault.getBounds().x + cmdDefault.getBounds().width + 10, lblSkip1stFase.getBounds().y + lblSkip1stFase.getBounds().height + 5, 98, 25);
        cmdStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                View_Startup.this.onStart();
            }
        });
        this.pnlMain.add(pnlSettings);
        pnlSettings.add(lblTeamSettings);
        pnlSettings.add(this.cbTeams);
        pnlSettings.add(lblMF);
        pnlSettings.add(cbMF);
        pnlSettings.add(lblSkip1stFase);
        pnlSettings.add(tbSkip1stFase);
        pnlSettings.add(cmdDefault);
        pnlSettings.add(cmdStart);
        this.pnlMain.add(scrollTeams);
    }

    private void onChangeTeams() {
        int i;
        this.NUM_TEAMS = (Integer)this.cbTeams.getSelectedItem();
        for (i = 0; i < this.NUM_TEAMS; ++i) {
            this.lblTeamName[i].setEnabled(true);
            this.tfTeamName[i].setEnabled(true);
            this.pnlTeamColor[i].setVisible(true);
        }
        for (i = this.NUM_TEAMS; i < this.MAX_TEAMS; ++i) {
            this.lblTeamName[i].setEnabled(false);
            this.tfTeamName[i].setEnabled(false);
            this.pnlTeamColor[i].setVisible(false);
        }
    }

    private void onDefault() {
        int bIsSure = JOptionPane.showConfirmDialog(null, "Are you sure you wish the reset all settings to their default value?", "Reset to default settings", 0);
        if (bIsSure == 0) {
            this.pnlMain.removeAll();
            this.updateInterface();
            this.repaint();
        }
    }

    private void onStart() {
        Team[] lstTeams = new Team[this.NUM_TEAMS];
        for (int i = 0; i < this.NUM_TEAMS; ++i) {
            Team tmpTeam;
            lstTeams[0] = tmpTeam = new Team(i + 1, this.pnlTeamColor[i].getBackground(), this.tfTeamName[i].getText());
        }
        this.setVisible(false);
        System.exit(0);
    }
}

